
# setwd('/Users/gfivash/Desktop/')
# file = 'hollowE6.csv'
# d = read.csv(file)
# d$time = as.POSIXct(d$time)
# 
# plot(d$rateWindow ~ d$tideTime, pch = '. ', log = 'y', cex = 2)
# plot(d$oxygen50.cm ~ d$tideTime, pch = '. ', cex = 2, ylim = c(6,-0.1))
# plot(d$oxygen50.cm ~ d$rateWindow, pch = '.', cex = 2)
# 
# which(d$tideTime == 0)
# 
# plot(d$rateWindow[1:217], pch = '.', cex = 2, ylim = c(0.1,6), log = 'y', xlim = c(0,400))
# plot(d$rateWindow[218:575], pch = '.', cex = 2, ylim = c(0.1,6), log = 'y', xlim = c(0,400))
# plot(d$rateWindow[576:933], pch = '.', cex = 2, ylim = c(0.1,6), log = 'y', xlim = c(0,400))
# plot(d$rateWindow[934:1291], pch = '.', cex = 2, ylim = c(0.1,6), log = 'y', xlim = c(0,400))
# plot(d$rateWindow[1292:(dim(d)[1]-1)], pch = '.', cex = 2, ylim = c(0.1,6), log = 'y', xlim = c(0,400))
# 
# #E1 Flat only (5 min interval)
# # d$tideTime[150:292] = (0:(length(150:292)-1))*(1/1.2)*(1/10)
# # d$tideTime[293:435] = (0:(length(293:435)-1))*(1/1.2)*(1/10)
# # d$tideTime[436:578] = (0:(length(436:578)-1))*(1/1.2)*(1/10)
# # d$tideTime[579:721] = (0:(length(579:721)-1))*(1/1.2)*(1/10)
# # d$tideTime[722:864] = (0:(length(722:864)-1))*(1/1.2)*(1/10)
# # d$tideTime[865:1008] = (0:(length(865:1008)-1))*(1/1.2)*(1/10)
# # d$tideTime[1009:1152] = (0:(length(1009:1152)-1))*(1/1.2)*(1/10)
# # d$tideTime[1153:dim(d)[1]] = (0:(length(1153:dim(d)[1])-1))*(1/1.2)*(1/10)
# 
# #Hummock & Hollow only (2 min interval)
# d$tideTime[1:217] = NA
# d$tideTime[218:575] = (0:(length(218:575)-1))*(1/3)*(1/10)
# d$tideTime[576:933] = (0:(length(576:933)-1))*(1/3)*(1/10)
# d$tideTime[934:1291] = (0:(length(934:1291)-1))*(1/3)*(1/10)
# d$tideTime[1292:(dim(d)[1]-1)] = (0:(length(1292:(dim(d)[1]-1))-1))*(1/3)*(1/10)
# d$tideTime[dim(d)[1]] = NA
# 
# d$tide.ID = NA
# for(i in 1:(length(which(d$tideTime == 0))-1)){
# d$tide.ID[which(d$tideTime == 0)[i]:which(d$tideTime == 0)[i + 1]] = i
# }
# i = length(which(d$tideTime == 0))
# d$tide.ID[which(d$tideTime == 0)[i]:max(which(!is.na(d$tideTime)))] = i
# 
# plot(d$rateWindow ~ d$tideTime, pch = '. ', log = 'y', cex = 2)
# plot(d$oxygen50.cm ~ d$tideTime, pch = '. ', cex = 2, ylim = c(6,-0.1))
# # write.csv(d,file, row.names = F)

# -------------------------------------------------------

csvDirectory = '/Users/gfivash/Desktop/Processed planar optode data/CSV submission/'
setwd(csvDirectory)
fileList = dir(pattern = '.csv')
n_files = length(fileList)

thresholdRate = 4.2
thresholdDepth = 0.15

col = c('green','yellow','blue')
sedimentShape_i = c('flat','hollow','hummock')

sedimentShape = c()
recoveryTime.hr = c()
duration.hr = c()
maxDepth.cm = c()
minRate = c()

counter = 1
for(i in 1:n_files){
  file = fileList[i]
  d = read.csv(file)
  
  i_tide = 1
  for(i_tide in 1:max(d$tide.ID, na.rm = T)){
    filter = d$tide.ID == i_tide
    plot(d$rateWindow[filter] ~ d$tideTime[filter],
         main = '', xlab = '', ylab = '', type = 'l',
         bty = 'n', xaxt = 'n', yaxt = 'n',
         ylim = c(0.1,5), xlim = c(0, 12),
         lwd = 3,log = 'y', cex = 3, col = alpha(col[i],0.5))
    ## Oxygen penetration depth (oxygen50)
    # plot(d$oxygen50.cm[filter] ~ d$tideTime[filter],
    #      main = i,
    #      ylim = c(6,-1), xlim = c(0, 12),
    #      lwd = 3, type = 'l', cex = 3, col = alpha(col[i],0.5))
    # lines(x = c(0,12), y = c(thresholdDepth,thresholdDepth))
    
    if(length(d$tideTime[d$oxygen50.cm > thresholdDepth  & d$tide.ID == i_tide & d$tideTime < 6 & !is.na(d$tideTime)]) == 0){
      duration.hr[counter] = 0
    } else {
      duration.hr[counter] = max(d$tideTime[d$oxygen50.cm > thresholdDepth  & d$tide.ID == i_tide & d$tideTime < 6], na.rm = T)
    }
    maxDepth.cm[counter] = max(d$oxygen50.cm[filter], na.rm = T)
    # lines(x = c(duration.hr[counter],duration.hr[counter]), y = c(-1,6), lty = 2)
    
    
    ##Oxygen decline rate (rate)
    plot(d$rateWindow[filter] ~ d$tideTime[filter],
         main = '', xlab = '', ylab = '', type = 'l',
         bty = 'n', xaxt = 'n', yaxt = 'n',
         ylim = c(0.1,5), xlim = c(0, 12),
         lwd = 3,log = 'y', cex = 3, col = alpha(col[i],0.5))
    # lines(x = c(0,12), y = c(thresholdRate,thresholdRate))
    
    if(length(d$tideTime[d$rateWindow < thresholdRate  & d$tide.ID == i_tide & d$tideTime < 6 & !is.na(d$tideTime)]) == 0){
      recoveryTime.hr[counter] = 0
    } else {
      recoveryTime.hr[counter] = min(d$tideTime[d$rateWindow > thresholdRate  & d$tide.ID == i_tide & d$tideTime > 0.3], na.rm = T)
    }
    minRate[counter] = min(d$rateWindow[filter], na.rm = T)
    # lines(x = c(recoveryTime.hr[counter],recoveryTime.hr[counter]), y = c(0.1,5), lty = 2)
    
    sedimentShape[counter] = sedimentShape_i[i]
    counter = counter + 1
  }
}

# -------------------------
sedimentShape = factor(sedimentShape, levels = c('hollow','flat','hummock'))
color = c('yellow','green','blue')

levels(sedimentShape) = c('Lowered','Flat',"Raised")


# ================
csvDirectory = '/Users/gfivash/Desktop/Processed planar optode data/CSV submission/'
setwd(csvDirectory)
fileList = dir(pattern = '.csv')
n_files = length(fileList)
i = 1

D = data.frame()
for(i in 1:3){
  file = fileList[i]
  d = read.csv(file)
  D = rbind(D,d)
}
d = D


thresholdHour = 6
# plot(d$rateWindow[d$tideTime > thresholdHour] ~ d$tideTime[d$tideTime > thresholdHour], 
#      ylim = c(0.1,5), log = 'y', col = color[d$sedimentShape[d$tideTime > thresholdHour]])

meanRate = c()
sedimentShape = c()
counter = 1
for(i_shape in 1:3){
  n_tides = max(d$tide.ID[d$sedimentShape == levels(d$sedimentShape)[i_shape]], na.rm = T)
  for(i_tide in 1:n_tides){
    sedimentShape[counter] = levels(d$sedimentShape)[i_shape]
    meanRate[counter] = mean(d$rate[d$tideTime > thresholdHour & 
                                      d$sedimentShape == levels(d$sedimentShape)[i_shape] & 
                                      d$tide.ID == i_tide], na.rm = T)
    counter = counter + 1
  }
}
meanRate[is.nan(meanRate)] = NA
sedimentShape = factor(sedimentShape, levels = c('hollow','flat','hummock'))
levels(sedimentShape) = c('Lowered','Flat',"Raised")

plotDirectory = '/Users/gfivash/Desktop/'
setwd(plotDirectory)
tiff("Figure S8abc.tif",width = 7, height = 3, units = 'in', res = 300)

par(mfrow = c(1,3))
plot(meanRate ~ sedimentShape, lwd = 0.8,
     ylim = c(0.1,5), log = 'y',
     xlab = 'Sediment shape', ylab = "Mean oxygen decline rate at low tide",
     col = alpha(color,0.5))
points(meanRate ~ sedimentShape, pch = 21, bg = alpha(color[sedimentShape], 0.5))
text(y = c(0.15,0.15,0.15),x = c(1,2,3), c('A','AB','B'))

m = aov(log(meanRate) ~ sedimentShape)
anova(m)
TukeyHSD(m)


# Oxygen decline rate
boxplot(minRate ~ sedimentShape, col = alpha(color,0.5), log = 'y', ylim = c(0.1,5), lwd = 0.8,
        xlab = 'Sediment shape',ylab = 'Oxygen decline rate at peak event')
points(minRate ~ sedimentShape, pch = 21, bg = alpha(color[sedimentShape], 0.5), lwd = 0.8)
text(y = c(0.15,0.15,0.15),x = c(1,2,3), c('A','AB','B'))
boxplot(recoveryTime.hr ~ sedimentShape, col = alpha(color,0.5), ylim = c(0,6), lwd = 0.8,
        ylab = 'Sediment shape',xlab = 'Recovery time (hours)', horizontal = T)
points(sedimentShape ~ recoveryTime.hr, pch = 21, bg = alpha(color[sedimentShape], 0.5), lwd = 0.8)
text(x = rep(5.6, times = 3),y = c(1,2,3), c('A','A','B'))
par(mfrow = c(1,1))

dev.off()

# # Depth of 50% oxygen saturation
# boxplot(duration.hr ~ sedimentShape, col = alpha(color,0.5), ylim = c(0,6))
# points(duration.hr ~ sedimentShape, pch = 21, bg = alpha(color[sedimentShape], 0.5))
# boxplot(maxDepth.cm ~ sedimentShape, col = alpha(color,0.5), ylim = c(5,0))
# points(maxDepth.cm ~ sedimentShape, pch = 21, bg = alpha(color[sedimentShape], 0.5))

mean(recoveryTime.hr[sedimentShape == 'Raised'])
sd(recoveryTime.hr[sedimentShape == 'Raised'])

mean(recoveryTime.hr[sedimentShape == 'Flat'])
sd(recoveryTime.hr[sedimentShape == 'Flat'])

mean(recoveryTime.hr[sedimentShape == 'Lowered'])
sd(recoveryTime.hr[sedimentShape == 'Lowered'])


# Statistics ----
m = aov(recoveryTime.hr ~ sedimentShape)
anova(m)
TukeyHSD(m)
m = aov(minRate ~ sedimentShape)
anova(m)
TukeyHSD(m)

# m = aov(duration.hr ~ sedimentShape)
# anova(m)
# TukeyHSD(m)
# m = aov(maxDepth.cm ~ sedimentShape)
# anova(m)
# TukeyHSD(m)

# --------------------

mean(meanRate[sedimentShape == 'Raised'])
sd(meanRate[sedimentShape == 'Raised'])

mean(meanRate[sedimentShape == 'Flat'], na.rm = T)
sd(meanRate[sedimentShape == 'Flat'], na.rm = T)

mean(meanRate[sedimentShape == 'Lowered'])
sd(meanRate[sedimentShape == 'Lowered'])

     
mean(minRate[sedimentShape == 'Raised'])
sd(minRate[sedimentShape == 'Raised'])

mean(minRate[sedimentShape == 'Flat'], na.rm = T)
sd(minRate[sedimentShape == 'Flat'], na.rm = T)

mean(minRate[sedimentShape == 'Lowered'])
sd(minRate[sedimentShape == 'Lowered'])

